package com.tykj.zydd.user.entity;

import com.tykj.zydd.misc.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;

import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;

/**
 * @author zsp@mail.com
 * @date 2022/11/7
 */
@Entity
@ApiModel("角色实体类")
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@SQLDelete(sql = "update science_role set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@Table(name = "science_role")
public class  KxRole extends BaseEntity {

    @ApiModelProperty(value = "角色名称")
    private String roleName;

    @ApiModelProperty(value = "角色描述")
    @Lob
    private String roleDesc;
}
