package com.tykj.zydd.user.init;

import com.tykj.zydd.user.service.ZyddUserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

@Component
@Slf4j
public class UserAndDepartmentInit {


    @Resource
    private ZyddUserService zyddUserService;



    @PostConstruct
    @Scheduled(cron = "0 0 12 * * ?")
    public void init(){
        log.info("开始更新部门人员");
        zyddUserService.cacheUnit();
        log.info("部门人员已更新");
    }
}
