package com.tykj.zydd.user.jwt;

import com.tykj.zydd.misc.constans.RedisKeyConstants;
import com.tykj.zydd.misc.constans.RedisTimeConstants;
import com.tykj.zydd.user.security.MyUserDetailsServiceImpl;
import com.tykj.zydd.user.security.SecurityUser;
import io.jsonwebtoken.*;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.Base64;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

/**
 * @author zhoushaopan
 */
@Component
public class JwtTokenProvider {


    @Resource
    private MyUserDetailsServiceImpl myUserDetailsServiceImpl;

    @Resource
    private StringRedisTemplate stringRedisTemplate;

    private String secretKey;

    @PostConstruct
    protected void init() {
        secretKey = Base64.getEncoder().encodeToString("pkslow.key".getBytes());
    }


    /**
     * 0 代表是管理员 1 代表是普通用户
     * @param userId
     * @param isBack
     * @return
     */
    public String createToken(String userId,String isBack) {

        Claims claims = Jwts.claims().setSubject(userId);
        claims.put("isBack", isBack);
        claims.put("userId", userId);
//        Date start = new Date();
        //7小时有效时间
//        long currentTime = System.currentTimeMillis() + 60 * 60 * 1000*24;
//        Date end = new Date(currentTime);
        return Jwts.builder()
                .setClaims(claims)
//                .setIssuedAt(start)
//                .setExpiration(end)
                .signWith(SignatureAlgorithm.HS256, secretKey)
                .compact();
    }


//    public String SpecificCreateToken(String accountId) {
//
//        Claims claims = Jwts.claims().setSubject(accountId);
//        claims.put("accountId", accountId);
////        Date start = new Date();
//        //7小时有效时间
////        long currentTime = System.currentTimeMillis() + 60 * 60 * 1000*24;
////        Date end = new Date(currentTime);
//        return Jwts.builder()
//                .setClaims(claims)
////                .setIssuedAt(start)
////                .setExpiration(end)
//                .signWith(SignatureAlgorithm.HS256, secretKey)
//                .compact();
//    }



    public Authentication getAuthentication(String token) {
        String userId = getUserId(token);
        String isBack = getIsBack(token);
        SecurityUser securityUser = (SecurityUser) myUserDetailsServiceImpl.loadUserByUsername(isBack+"Ǵ"+userId);
        return new UsernamePasswordAuthenticationToken(securityUser, "", securityUser.getAuthorities());
    }

    public String getUserId(String token) {
        Claims body = Jwts.parser().setSigningKey(secretKey).parseClaimsJws(token).getBody();
        return (String) body.get("userId");

    }

    public String getIsBack(String token) {
        Claims body = Jwts.parser().setSigningKey(secretKey).parseClaimsJws(token).getBody();
        return (String) body.get("isBack");

    }

    public Claims getClaims(String token) {
        return Jwts.parser().setSigningKey(secretKey).parseClaimsJws(token).getBody();
    }

    /**
     * 解析token
     * @param req 请求流
     * @return token字符串
     */
    public String resolveToken(HttpServletRequest req) {
        String bearerToken = req.getHeader("Authorization");
        if (bearerToken != null && bearerToken.startsWith("Bearer ")) {
            return bearerToken.substring(7);
        }
        return null;
    }


    /**
     * 验证token
     * @param token token
     * @return 返回true或者false
     */
    public Boolean redisValidToken(String token) {
        //不存在该key 说明该token 无效
        return Optional.ofNullable(stringRedisTemplate.hasKey(RedisKeyConstants.TOKEN+ token))
                .orElse(false);
    }

    /**
     * 刷新token的过期时间
     * @param token
     */
    public void flashToken(String token) {
        //不存在该key 说明该token 无效
         stringRedisTemplate.expire(RedisKeyConstants.TOKEN+token, RedisTimeConstants.TOKEN_TIME, TimeUnit.MINUTES);
    }

}
