package com.tykj.zydd.user.service;

import com.alibaba.xxpt.gateway.shared.api.response.*;
import com.alibaba.xxpt.gateway.shared.client.http.IntelligentGetClient;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.tykj.zydd.user.entity.dto.SendWorkMessageDTO;
import com.tykj.zydd.user.entity.vo.UserMessageVO;

import java.util.List;

public interface ZyddUserService {
     /**
      * 用户获取token
      */
     String getAccessToken();

     /**
      * 根据应用token跟零时授权码获取用户信息
      */
     UserMessageVO getUserMessage(String authCode) throws JsonProcessingException;

     /**
      * 获取组织
      */
     OapiMoziFusionGetOrganizationTypesResponse getUnit();

     /**
      * 获取通讯录权限范围
      */
     String getIntelligent();

     /**
      * 获取部门下级
      */
     List<String> getSubordinateOrganization(String organizationCodes);


     /**
      * 批量根据组织code查询部门信息
      */
     OapiMoziOrganizationListOrganizationsByCodesResponse getOrganizations(List<String> codeList);



     /**
      * 查询部门下的人员信息
      */
     OapiMoziOrganizationPageOrganizationEmployeePositionsResponse getSpecificUser(String organizationCodes);


     /**
      * 发送工作通知
      */
     boolean sendWorkMessage(SendWorkMessageDTO sendWorkMessageDTO);

     /**
      * 更新单位
      */
     void cacheUnit();


//     List<String> test(String data, List<String> list);
}
