package com.tykj.zydd.user.service.impl;


import com.tykj.zydd.user.dao.ScienceIpDao;
import com.tykj.zydd.user.entity.ScienceIp;
import com.tykj.zydd.misc.util.IpUtil;
import com.tykj.zydd.user.service.ScienceIpService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;

/**
 * @author: zsp
 * @create: 2023-12-29 11:43
 **/
@Service
@Slf4j
public class ScienceIpServiceImpl implements ScienceIpService {

    @Resource
    private ScienceIpDao scienceIpDao;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveIp(HttpServletRequest request) {
        String ipAddress = IpUtil.getIpAddress(request);
        String deviceModel = IpUtil.getDeviceModel(request);
        String userAgent = IpUtil.getUserAgent(request);
        ScienceIp build = ScienceIp.builder()
                .ipAddress(ipAddress)
                .modelOrigin(deviceModel)
                .loginTime(LocalDateTime.now())
                .userAgent(userAgent)
                .build();
        scienceIpDao.save(build);
        log.info("保存IP地址信息：{}", build);
    }
}
