/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.xxpt.gateway.shared.client.http;

import com.alibaba.xxpt.gateway.shared.client.NetworkUtils;
import com.alibaba.xxpt.gateway.shared.client.sign.Signature;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpUriRequest;

public abstract class AbstractRequest {
    private final int timeout;
    private final String version;
    private String accessKey;
    private String secretKey;
    private Signature signature;

    public AbstractRequest(int timeout, String version) {
        this.timeout = timeout;
        this.version = version;
        this.signature = Signature.newInstance();
    }

    public HttpUriRequest getHttpRequest() {
        String algorithm;
        HttpUriRequest request = this.newHttpRequest();
        this.signature.method(this.methodName()).path(request.getURI().getPath()).secretKey(this.secretKey);
        Header header = request.getFirstHeader("X-Hmac-Auth-Algorithm");
        String signStr = header == null ? this.signature.sign() : (StringUtils.equals((CharSequence)(algorithm = header.getValue()), (CharSequence)"md5") ? this.signature.signMd5() : this.signature.sign());
        request.addHeader("apiKey", this.accessKey);
        request.addHeader("X-Hmac-Auth-Signature", signStr);
        request.addHeader("X-Hmac-Auth-Timestamp", this.signature.getTimestamp());
        request.addHeader("X-Hmac-Auth-Version", this.version);
        request.addHeader("X-Hmac-Auth-Nonce", this.signature.getNonce());
        request.addHeader("X-Hmac-Auth-IP", NetworkUtils.getIp());
        request.addHeader("X-Hmac-Auth-MAC", NetworkUtils.getMac());
        return request;
    }

    protected abstract HttpUriRequest newHttpRequest();

    public abstract String methodName();

    public int getTimeout() {
        return this.timeout;
    }

    public void addSignParameter(String name, String value) {
        this.signature.addParameter(name, value);
    }

    public void addSignBody(String body) {
        this.signature.addBody(body);
    }

    public AbstractRequest accessKey(String accessKey) {
        this.accessKey = accessKey;
        return this;
    }

    public AbstractRequest secretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    protected boolean isEmpty(String str) {
        return str == null || "".equals(str.trim());
    }
}

