package com.tykj.zydd.misc.exception;


import com.tykj.zydd.misc.base.ResponseObj;
import org.springframework.http.HttpStatus;

/**
 * 全局错误处理类，用于处理一些不容易定义的错误
 *
 * @author HuangXiahao
 **/
public class ApiException extends RuntimeException {

    private final ResponseObj responseObj;

    public ApiException(ResponseObj responseObj){
        this.responseObj = responseObj;
    }

    public ApiException(String message) {
        this.responseObj = new ResponseObj(message, HttpStatus.NO_CONTENT+"");
    }

    public ApiException(String message,String errorCode){
        this.responseObj = new ResponseObj(message,errorCode);
    }

    public ResponseObj getResponseObj() {
        return responseObj;
    }
}
