package com.tykj.zydd.misc.page;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "统一返回分页数据", description = "统一返回分页数据")
public class PageWebVO<T> {

    @ApiModelProperty(value = "总记录数")
    private Long totalRecords;

    @ApiModelProperty(value = "当前页")
    private Integer page = 0;

    @ApiModelProperty(value = "每页数")
    private Integer size = 10;

    @ApiModelProperty(value = "数据")
    private List<T> data;

}

