package com.tykj.zydd.misc.util;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

/**
 * @author sc
 * @create 2023-11-27
 */
public class PinyinUtil {


    public static String getNamePinYin(String name) {
        // 创建汉语拼音输出格式对象
        HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
        // 设置拼音小写
        format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        // 设置不显示声调
        format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);

        StringBuilder sb = new StringBuilder();
        char[] chars = name.toCharArray();
        for (int i = 0; i < chars.length; i++) {
            // 拼音数组
            String[] pinyins;
            try {
                // 将汉字转化为拼音数组
                pinyins = PinyinHelper.toHanyuPinyinStringArray(chars[i], format);
            } catch (BadHanyuPinyinOutputFormatCombination e) {
                e.printStackTrace();
                // 处理异常情况，直接将当前字符加入结果中
                sb.append(chars[i]);
                continue;
            }
            if (pinyins == null || pinyins.length == 0) {
                // 当前字符不是汉字，直接加入结果中
                sb.append(chars[i]);
            } else {
                if (i == 0) {
                    // 第一个字的拼音首字母大写，其他字符小写
                    sb.append(Character.toUpperCase(pinyins[0].charAt(0)));
                    sb.append(pinyins[0].substring(1).toLowerCase());
                } else {
                    // 其他字只取首字母大写
                    sb.append(Character.toUpperCase(pinyins[0].charAt(0)));
                }
            }
        }
        return sb.toString();
    }
}
