package com.tykj.zydd.misc.util.poi;

import org.apache.poi.ss.usermodel.Workbook;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;


public class ExportExcelUtil {

    public static void outExcelFile(Workbook workbook, HttpServletResponse response, String fileName) {
        // 输出Excel文件
        try {
            OutputStream outputStream = response.getOutputStream();
            // 下面几行是为了解决文件名乱码的问题
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes(), StandardCharsets.UTF_8) + ".xlsx");
            response.setContentType("application/vnd.ms-excel;charset=UTF-8");
            //关闭缓存
            response.setHeader("Pragma", "no-cache");
            //关闭缓存
            response.setHeader("Cache-Control", "no-cache");
            //为了让浏览器不要缓存页面，也可以利用Expires实体报关域，设置为0
            response.setDateHeader("Expires", 0);
            workbook.write(outputStream);
            workbook.close();
            outputStream.close();
        } catch (IOException e) {
            e.printStackTrace();
        }

    }
}
