package com.tykj.zydd.pickup.controller;

import com.tykj.zydd.misc.swagger.AutoDocument;
import com.tykj.zydd.pickup.entity.Template;
import com.tykj.zydd.pickup.entity.dto.TemplateDTO;
import com.tykj.zydd.pickup.service.TemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

@RestController
@Api(tags = "通知模板")
@Slf4j
@RequestMapping("/tc")
@AutoDocument
public class TemplateController {

    @Resource
    private TemplateService templateService;



    @GetMapping("/getListTemplate")
    @ApiOperation(value = "查询模板")
    public List<Template> getListTemplate(){
        return templateService.getListTemplate();
    }

    @PostMapping("/addOrUpdate")
    @ApiOperation(value = "修改或者添加模板")
    public void addOrUpdate(@RequestBody TemplateDTO templateDTO){
        templateService.saveTemplate(templateDTO);
    }

    @GetMapping("/deleteById")
    @ApiOperation(value = "删除模板")
    public void deleteById(@RequestParam Integer id){
        templateService.deleteById(id);
    }
}
