package com.tykj.zydd.pickup.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;

import javax.persistence.Entity;

@Data
@ApiModel("模板")
@Entity
@SQLDelete(sql = "update template set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
public class Template extends BaseEntity{
    @ApiModelProperty(value = "模板名称")
    private String templateName;

    @ApiModelProperty(value = "模板内容")
    private String content;

    @ApiModelProperty(value = "单位id")
    private String organizationCode;
}
