package com.tykj.zydd.pickup.service.impl;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.zydd.misc.exception.ApiException;
import com.tykj.zydd.pickup.dao.PickUpDAO;
import com.tykj.zydd.pickup.entity.PickUp;
import com.tykj.zydd.pickup.entity.dto.ManualOperationDTO;
import com.tykj.zydd.pickup.entity.dto.NotificationDTO;
import com.tykj.zydd.pickup.entity.dto.PickUpDTO;
import com.tykj.zydd.pickup.entity.vo.NotificationVO;
import com.tykj.zydd.pickup.entity.vo.UserVO;
import com.tykj.zydd.pickup.service.PickUpService;
import com.tykj.zydd.user.dao.KxAdminDao;
import com.tykj.zydd.user.dao.SpecificUnitDao;
import com.tykj.zydd.user.dao.SpecificUserDao;
import com.tykj.zydd.user.dao.SpecificUserMessageDao;
import com.tykj.zydd.user.entity.KxAdmin;
import com.tykj.zydd.user.entity.SpecificUnit;
import com.tykj.zydd.user.entity.SpecificUser;
import com.tykj.zydd.user.entity.SpecificUserMessage;
import com.tykj.zydd.user.entity.dto.SendWorkMessageDTO;
import com.tykj.zydd.user.service.ZyddUserService;
import com.tykj.zydd.user.utils.UserUtils;
import org.apache.catalina.User;
import org.apache.tomcat.jni.Local;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.rmi.CORBA.Util;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class PickUpServiceImpl implements PickUpService {


    @Resource
    private PickUpDAO pickUpDAO;

    @Resource
    private SpecificUnitDao specificUnitDao;

    @Resource
    private SpecificUserMessageDao specificUserMessageDao;

    @Resource
    private SpecificUserDao specificUserDao;

    @Resource
    private KxAdminDao kxAdminDao;

    @Resource
    private ZyddUserService zyddUserService;

    @Resource
    private UserUtils userUtils;


    @Override
    public List<PickUp> getListPickUp(PickUpDTO pickUpDTO) {
        PredicateBuilder<PickUp> predicateBuilder = Specifications.and();
        KxAdmin currentUser = userUtils.getCurrentUser();
        predicateBuilder.eq("organizationCode", currentUser.getOrganizationCode());
        predicateBuilder.eq(pickUpDTO.getToUnitName() != null, "toUnitName", pickUpDTO.getToUnitName());
        if (pickUpDTO.getTime() != null) {
            LocalDateTime time = pickUpDTO.getTime();
            LocalDateTime startOfDay = time.toLocalDate().atStartOfDay();
            LocalDateTime endOfDay = time.toLocalDate().atTime(LocalTime.MAX);
            predicateBuilder.ge("notificationTime", startOfDay);
            predicateBuilder.le("notificationTime", endOfDay);
        }
        return pickUpDAO.findAll(predicateBuilder.build());
    }

    @Override
    public void addPickUp(ManualOperationDTO manualOperationDTO) {
        List<String> unitList = manualOperationDTO.getUnitList();
        KxAdmin currentUser = userUtils.getCurrentUser();
        for (String unit : unitList) {
            PickUp pickUp = new PickUp();
            pickUp.setToUnitName(unit);
            LocalDateTime now = LocalDateTime.now();
            pickUp.setNotificationTime(now);
            pickUp.setFromUnitName(currentUser.getOrganizationName());
            pickUp.setFromUser(currentUser.getUsername());
            pickUp.setToUnitName(unit);
        }
    }


    @Override
    public List<NotificationVO> getNotificationList(List<String> unitName) {
        List<NotificationVO> rs = new ArrayList<>();
        List<SpecificUser> userAll = specificUserDao.findAll();
        List<SpecificUnit> all = specificUnitDao.findAll();
        List<SpecificUserMessage> userMessageAll = specificUserMessageDao.findAll();
        List<KxAdmin> kxAdmins = kxAdminDao.findAll();
        for (String s : unitName) {
            NotificationVO vo = new NotificationVO();
            List<UserVO> userVOS = new ArrayList<>();
            vo.setUnitName(s);
            //查找详细信息获取单位code
            SpecificUnit specificUnit = all.stream().filter(a -> a.getOrganizationName().equals(s)).findFirst().orElse(new SpecificUnit());
            //根据code查询该单位下的人员id
            List<Integer> collect = userMessageAll.stream().filter(a -> a.getOrganizationCode().equals(specificUnit.getOrganizationCode()) && a.getEnable() == 0)
                    .map(SpecificUserMessage::getUserId)
                    .collect(Collectors.toList());
            for (Integer integer : collect) {
                UserVO userVO = new UserVO();
                SpecificUser specificUser = userAll.stream().filter(a -> a.getId().equals(integer)).findFirst().orElse(new SpecificUser());
                userVO.setUserName(specificUser.getEmployeeName());
                KxAdmin kxAdmin = kxAdmins.stream().filter(a -> a.getUsername().equals(specificUser.getEmployeeName())).findFirst().orElse(new KxAdmin());
                if (kxAdmin.getAccount() == null) {
                    throw new ApiException(specificUser.getEmployeeName() + "该用户没有从钉钉免登请先从钉钉登入");
                }
                userVO.setAccountId(kxAdmin.getAccount());
                userVOS.add(userVO);
            }
            vo.setUserVOS(userVOS);
            rs.add(vo);
        }
        return rs;
    }

    @Override
    public void notification(List<NotificationDTO> notificationDTOList) {
        for (NotificationDTO notificationDTO : notificationDTOList) {
            KxAdmin byUserName = kxAdminDao.findByUsername(notificationDTO.getUser());
            SpecificUser byEmployeeName = specificUserDao.findByEmployeeName(notificationDTO.getUser());
            SpecificUserMessage byUserId = specificUserMessageDao.findByUserId(byEmployeeName.getId());
            KxAdmin currentUser = userUtils.getCurrentUser();
            if (byUserId.getEnable() == 1) {
                PickUp pickUp = new PickUp();
                LocalDateTime now = LocalDateTime.now();
                pickUp.setNotificationTime(now);
                pickUp.setFromUnitName(currentUser.getOrganizationName());
                pickUp.setFromUser(currentUser.getUsername());
                pickUp.setToUnitUser(notificationDTO.getUser());
                pickUp.setToUnitName(notificationDTO.getToUnitName());
                pickUp.setStatus(1);
                pickUp.setOrganizationCode(currentUser.getOrganizationCode());
                pickUpDAO.save(pickUp);
                throw new ApiException("该用户为被启用");
            }
            SendWorkMessageDTO sendWorkMessageDTO = new SendWorkMessageDTO();
            sendWorkMessageDTO.setContent(notificationDTO.getContent());
            sendWorkMessageDTO.setReceiverIds(byUserName.getAccount());
            boolean flag = zyddUserService.sendWorkMessage(sendWorkMessageDTO);
            PickUp pickUp = new PickUp();
            LocalDateTime now = LocalDateTime.now();
            pickUp.setNotificationTime(now);
            pickUp.setFromUnitName(currentUser.getOrganizationName());
            pickUp.setFromUser(currentUser.getUsername());
            pickUp.setToUnitUser(notificationDTO.getUser());
            pickUp.setToUnitName(notificationDTO.getToUnitName());
            if (flag) {
                pickUp.setStatus(0);
            } else {
                pickUp.setStatus(1);
            }
            pickUp.setOrganizationCode(currentUser.getOrganizationCode());
            pickUpDAO.save(pickUp);
        }
    }

}
