package com.tykj.zydd.union;

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@SpringBootApplication(scanBasePackages = {
        "com.tykj.zydd.*"
})
@EnableJpaAuditing
@EnableSwagger2
@EnableTransactionManagement
@EnableScheduling
@EnableCaching
@Slf4j
public class UnionApplication {
    public static void main(String[] args) {
        SpringApplication.run(UnionApplication.class,args);
    }
}
