package com.tykj.zydd.user.contorller;

import com.tykj.zydd.user.entity.KxAdmin;
import com.tykj.zydd.user.entity.vo.UserMessageVO;
import com.tykj.zydd.user.entity.vo.admin.LoginSystemVO;
import com.tykj.zydd.user.entity.vo.admin.RegisterVO;
import com.tykj.zydd.misc.aop.Timer;
import com.tykj.zydd.misc.swagger.AutoDocument;
import com.tykj.zydd.user.security.SecurityUser;
import com.tykj.zydd.user.service.KxAdminService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @author: zsp
 * @create: 2023-12-27 10:38
 **/
@RestController
@RequestMapping("/admin")
//@Api(value = "后台人员接口",description = "提供后台人员接口")
@Api(tags = "后台登录")
@AutoDocument
public class KxAdminController {

    @Resource
    private KxAdminService kxAdminService;

    @PostMapping("/register")
    @ApiOperation(value = "后台人员注册",notes = "后台人员注册")
    @Timer(desc = "后台人员注册")
    public ResponseEntity<KxAdmin> register(@RequestBody RegisterVO registerVO){
        return ResponseEntity.ok(kxAdminService.registeredBySystem(registerVO));
    }

    @PostMapping("/loginSystem")
    @ApiOperation(value = "后台人员登录(本系统)",notes = "后台人员登录(本系统)")
    @Timer(desc = "后台人员登录(本系统)")
    public ResponseEntity<SecurityUser> loginSystem(@RequestBody LoginSystemVO loginSystemVO){
        return ResponseEntity.ok(kxAdminService.loginBySystem(loginSystemVO));
    }

    @PostMapping("/loginByUserMessageVO")
    @ApiOperation(value = "模拟浙政钉登录接口")
    public  UserMessageVO loginByUserMessageVO(@RequestBody LoginSystemVO loginSystemVO){
        return kxAdminService.loginByUserMessageVO(loginSystemVO);
    }



//    @GetMapping("/login")
//    @ApiOperation(value = "外部系统登录接口",notes = "外部系统登录接口")
//    @Timer(desc = "外部系统登录接口")
//    public ResponseEntity<SecurityUser> login(String code){
//        return ResponseEntity.ok(kxAdminService.login(code));
//    }

}
