package com.tykj.zydd.user.contorller;

import com.alibaba.xxpt.gateway.shared.api.request.OapiMessageWorkNotificationRequest;
import com.alibaba.xxpt.gateway.shared.api.response.*;
import com.alibaba.xxpt.gateway.shared.client.http.IntelligentGetClient;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.tykj.zydd.user.entity.dto.SendWorkMessageDTO;
import com.tykj.zydd.user.entity.vo.UserMessageVO;
import com.tykj.zydd.user.init.AppKeyInit;
import com.tykj.zydd.misc.swagger.AutoDocument;
import com.tykj.zydd.user.service.ZyddUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;


@RestController
@Api(tags = "浙政钉获取信息")
@Slf4j
@RequestMapping("/user")
@AutoDocument
public class UserController {

    @Resource
    private AppKeyInit appKeyInit;

    @Resource
    private ZyddUserService zyddUserService;
//    @ApiOperation(value = "获取token")
//    @GetMapping("/getToken")
//    public OapiGettokenJsonResponse getToken(){ IntelligentGetClient intelligentGetClient = appKeyInit.getExecutableClient().newIntelligentGetClient("/gettoken.json");
//        OapiGettokenJsonRequest oapiGettokenJsonRequest = new OapiGettokenJsonRequest();
//        //应用的唯一标识key
//        oapiGettokenJsonRequest.setAppkey(1+"");
//        //应用的密钥
//        oapiGettokenJsonRequest.setAppsecret(appKeyInit.getSecret());
//        //获取结果
//        OapiGettokenJsonResponse apiResult = intelligentGetClient.get(oapiGettokenJsonRequest);
//        return apiResult;
//    }

    @ApiOperation(value = "获取access_token")
    @GetMapping("/getAccessToken")
    public String getAccessToken(){
        return zyddUserService.getAccessToken();
    }

    @ApiOperation(value = "获取用户信息")
    @GetMapping("/getUserMessage")
    public UserMessageVO getUserMessage( @RequestParam String authCode) throws JsonProcessingException {
        return zyddUserService.getUserMessage(authCode);
    }

    @ApiOperation(value = "获取单位")
    @GetMapping("/getUnit")
    public OapiMoziFusionGetOrganizationTypesResponse getUnit(){
        return zyddUserService.getUnit();
    }

    @ApiOperation(value = "获取通讯录权限范围(最大部门code)")
    @GetMapping("/getIntelligent")
    public String getIntelligent(){
      return  zyddUserService.getIntelligent();
    }

    @ApiOperation(value = "获取部门的下级（分页）")
    @GetMapping("/getSubordinateOrganization")
    public List<String> getSubordinateOrganization(String organizationCodes){
        return  zyddUserService.getSubordinateOrganization(organizationCodes);
    }

    @ApiOperation(value = "批量根据部门code查询部门信息")
    @PostMapping("/getOrganizations")
    public OapiMoziOrganizationListOrganizationsByCodesResponse getOrganizations(@RequestParam List<String> codeList){
        return zyddUserService.getOrganizations(codeList);
    }

    @ApiOperation(value = "查询部门下的员工信息")
    @GetMapping("/getSpecificUser")
    public OapiMoziOrganizationPageOrganizationEmployeePositionsResponse getSpecificUser(@RequestParam String organizationCodes){
        return zyddUserService.getSpecificUser(organizationCodes);
    }

    @ApiOperation(value = "发送工作通知")
    @PostMapping ("/sendWorkMessage")
    public void sendWorkMessage(@RequestBody SendWorkMessageDTO sendWorkMessageDTO){
          zyddUserService.sendWorkMessage(sendWorkMessageDTO);
    }





    @ApiOperation(value = "拉取部门人员信息入库")
    @GetMapping("/cacheUnit")
    public void test(){
        zyddUserService.cacheUnit();
    }



    public static void main(String[] args) {
        List<String> a=new ArrayList<>();
        a.add("GO_a0ef890b75b349e4aaba18d65352b99d");
        a.add("GO_13fff25685cf4a14b1dcda6257dc5e32");
        System.out.println(a);
    }
}
