package com.tykj.zydd.user.dao;

import com.tykj.zydd.user.entity.SpecificUser;
import com.tykj.zydd.user.entity.SpecificUserMessage;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface SpecificUserMessageDao extends JpaRepository<SpecificUserMessage,Integer>, JpaSpecificationExecutor<SpecificUserMessage> {

    /**
     * 根据员工code查询员工信息
     */
    SpecificUserMessage findFirstByEmployeeCode(String employeeCode);

    /**
     * 修改指定用户的状态
     */
    @Modifying
    @Query("update SpecificUserMessage s set s.enable = :enable where s.userId = :id")
    @Transactional
    void updateEnable(@Param("id") int id,@Param("enable") int enable);


    /**
     * 根据单位code查询可用人员
     */
   List<SpecificUserMessage> findAllByOrganizationCodeAndEnable(String organizationCode,Integer enable);

    /**
     * 根据关联字段查询信息
     */
   SpecificUserMessage findByUserId(Integer userId);
}
