package com.tykj.zydd.user.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.tykj.zydd.misc.base.BaseEntity;
import com.tykj.zydd.misc.sm_utils.Sm4AttributeConverter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.time.LocalDate;
import java.util.List;

/**
 * @author zsp
 * @date 2022/9/22
 */
@Entity
@ApiModel("管理员实体类")
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@SQLDelete(sql = "update science_admin set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@Table(name = "zydd_admin")
public class KxAdmin extends BaseEntity {

    @ApiModelProperty(value = "电话号码",example = "123")
    @Convert(converter = Sm4AttributeConverter.class)
    private String telephone;

    @ApiModelProperty(value = "账号",example = "123")
    @Convert(converter = Sm4AttributeConverter.class)
    private String account;

    @ApiModelProperty(name = "密码",value = "密码",example = "123")
    private String password;

    @ApiModelProperty(value = "盐")
    private String salt;

    @ApiModelProperty(value = "来源",example = "0 本系统 1 外部系统")
    private String origin;

    @ApiModelProperty(value = "外来系统人员ID",example = "外来系统人员ID，本系统的的人员ID为空或者0")
    private String systemUserId;

    @ApiModelProperty(value = "用户名",example = "123")
    @Convert(converter = Sm4AttributeConverter.class)
    private String username;

    @ApiModelProperty("所属单位")
    private String organizationCode;

    @ApiModelProperty("单位名称")
    private String organizationName;

    @ApiModelProperty("是否是市级账号 0代表是 1代表不是")
    private Integer level;
}
