package com.tykj.zydd.user.entity;

import com.tykj.zydd.misc.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;

import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @author: zsp
 * @create: 2022-12-13 15:42
 **/
@Entity
@ApiModel("权限角色实体类")
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@SQLDelete(sql = "update science_role_permissions set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@Table(name = "science_role_permissions")
public class KxRolePermissions extends BaseEntity {

    @ApiModelProperty(value = "权限Id")
    private Integer permissionId;

    @ApiModelProperty(value = "角色ID")
    private Integer roleId;

}
