package com.tykj.zydd.user.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

/**
 * @author: zsp
 * @create: 2023-06-27 13:14
 **/
@ApiModel(value = "前台人员和后台管理员中间表")
@AllArgsConstructor
@NoArgsConstructor
@Data
@Builder
@Entity(name = "science_user_admin")
public class KxUserAdmin {

    /**
     * 主键id
     */
    @Id
    @GeneratedValue(strategy= GenerationType.IDENTITY)
    private Integer id;

    @ApiModelProperty(value = "浙里办的人的唯一标识",example = "张a")
    private String userIdentity;

    @ApiModelProperty(value = "后台管理员ID")
    private Integer adminId;
}
