package com.tykj.zydd.user.entity;

import com.tykj.zydd.misc.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;

import javax.persistence.Entity;

@Data
@ApiModel("专有钉钉用户父信息")
@Entity
@SQLDelete(sql = "update Specific_user set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
public class SpecificUser extends BaseEntity {

    @ApiModelProperty("员工名称")
    private String employeeName;

    @ApiModelProperty("政治面貌")
    private String empJobLevelCode;

    @ApiModelProperty("编制")
    private String empBudgetedPostCode;

    @ApiModelProperty("员工创建时间")
    private String gmtCreate;

    @ApiModelProperty("员工性别")
    private String empGender;

    @ApiModelProperty("员工Code")
    private String employeeCode;

    @ApiModelProperty("人员状态，A 在职； F 离职")
    private String status;

}
