package com.tykj.zydd.user.entity;

import com.tykj.zydd.misc.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;

import javax.persistence.Entity;

@Data
@ApiModel("专有钉钉用户子信息")
@Entity
@SQLDelete(sql = "update Specific_user_Message set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
public class SpecificUserMessage extends BaseEntity {
    @ApiModelProperty("")
    private String visibilityIndicatorCode;

    @ApiModelProperty("任职属性")
    private String jobAttributesCode;

    @ApiModelProperty("部门编码")
    private String organizationCode;

    @ApiModelProperty("是否主职")
    private String mainJob;

    @ApiModelProperty("任职在组织内排序")
    private Long orderInOrganization;

    @ApiModelProperty("是否主职")
    private String empPosUnitCode;

    @ApiModelProperty("员工创建时间")
    private String gmtCreate;

    @ApiModelProperty("")
    private String empPosEmployeeRoleCode;

    @ApiModelProperty("员工Code")
    private String employeeCode;

    @ApiModelProperty("状态")
    private String status;

    @ApiModelProperty("关联用户表id")
    private Integer userId;

    @ApiModelProperty("是否启用 0启用 1停止")
    private Integer enable=1;
}
