package com.tykj.zydd.user.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;

/**
 * @author zsp
 * @date 2022/10/11
 */
@ApiModel("返回统一人员信息vo")
@Data
public class UserInfoVO {

    @ApiModelProperty(value = "用户标识")
    private String userIdentity;

    @ApiModelProperty(value = "手机号码")
    private String telephone;

    @ApiModelProperty(value = "用户名")
    private String userName;

    @ApiModelProperty(value = "用户ID")
    private Integer id;

    @ApiModelProperty(value = "密码")
    private String password;

    @ApiModelProperty(value = "登陆时间",example = "2022-10-01")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private LocalDate loginDate;

    @ApiModelProperty(value = "头像地址",example = "123")
    private String imgPath;

    @ApiModelProperty(value = "修改资料的标识位",example = "{0 代表未修改 1 代表管理员}")
    private Integer updated;

    @ApiModelProperty(value = "科普ID",example = "{科普ID}")
    private String kpId;

    @ApiModelProperty(value = "是否是管理员",example = "{0 是管理员 1 不是管理员}")
    private Integer isBack;

    @ApiModelProperty(value = "管理员类型",notes = "0 基地管理员 1 正常科协管理员")
    private Integer adminType;

    @ApiModelProperty(value = "上次修改密码的时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private LocalDate updatePasswordDate;

    @ApiModelProperty(value = "是否需要修改密码",example = "true 需要 false不需要")
    private Boolean updatePasswordFlag = false;

    @ApiModelProperty(value = "盐")
    private String salt;

    @ApiModelProperty(value = "账号",example = "123")
    private String account;


}
