package com.tykj.zydd.user.entity.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.tykj.zydd.misc.sm_utils.Sm4AttributeConverter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Convert;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.time.LocalDateTime;

/**
 * @author: zsp
 * @create: 2023-12-29 11:41
 **/
@ApiModel( value = "ip dto", description = "ip dto")
@AllArgsConstructor
@NoArgsConstructor
@Data
public class IpDTO {

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    public Integer id;

    @ApiModelProperty(name =  "IP地址")
    public String ipAddress;

    @ApiModelProperty(name =  "设备型号")
    public String modelOrigin;

    @ApiModelProperty(name =  "设备型号")
    public String userAgent;

    @ApiModelProperty(name = "登录用户名")
    @Convert(converter = Sm4AttributeConverter.class)
    public String username;

    @ApiModelProperty(name = "登录时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    public LocalDateTime loginTime;

    @ApiModelProperty(value = "登录来源")
    public String origin;
}
