package com.tykj.zydd.user.entity.dto;

import com.tykj.zydd.misc.sm_utils.Sm4AttributeConverter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Convert;

/**
 * @author: zsp
 * @create: 2023-12-27 14:54
 **/
@ApiModel( value = "安全框架统一返回对象", description = "安全框架统一返回对象")
@AllArgsConstructor
@NoArgsConstructor
@Data
public class UserInfo {

    private Integer id;

    @ApiModelProperty(value = "电话号码",example = "123")
    @Convert(converter = Sm4AttributeConverter.class)
    private String telephone;

    @ApiModelProperty(value = "账号",example = "123")
    @Convert(converter = Sm4AttributeConverter.class)
    private String account;

    @ApiModelProperty(name = "密码",value = "密码",example = "123")
    private String password;

    private String username;




}
