package com.tykj.zydd.user.enums;

import java.util.HashMap;
import java.util.Map;

public enum AreaEnum {
    ZJS_AREA("330000","浙江省"),
    TZS_AREA("331000","台州市"),
    YHS_AREA("331083","玉环市"),
    HYQ_AREA("331003","黄岩区"),
    XJX_AREA("331024","仙居县"),
    JJQ_AREA("331002","椒江区"),
    LHS_AREA("331082","临海市"),
    LQQ_AREA("331004","路桥区"),
    SMX_AREA("331022","三门县"),
    WLS_AREA("331081","温岭市"),
    TTX_AREA("331023","天台县"),
    CS_HZ("330102","滨江区")
    ;

    private String code;

    private String name;

    AreaEnum(String code, String name){
        this.code=code;
        this.name=name;
    }
    public void setCode(String code) {
        this.code = code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static String getNameByCode(String code) {
        //通过反射取出Enum所有常量的属性值
        for (AreaEnum educationEnum : values()) {
            //利用code进行循环比较，获取对应的枚举
            if (code.equals(educationEnum.getCode())) {
                return educationEnum.getName();
            }
        }
        return null;
    }

    /**
     * 转成map name，code
     * @return
     */
    public static Map<String,String> getMap() {
        Map<String,String> map = new HashMap<>();
        //通过反射取出Enum所有常量的属性值
        for (AreaEnum areaEnum : values()) {
            map.put(areaEnum.getName(),areaEnum.getCode());
        }
        return map;
    }
}
