package com.tykj.zydd.user.init;

import com.alibaba.xxpt.gateway.shared.client.http.ExecutableClient;
import lombok.Data;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

@Component
@Data
public class AppKeyInit {

    @Value("${app.key}")
    private String key;

    @Value("${app.secret}")
    private String secret;

    @Value("${domainName}")
    private String domainName;



    private static ExecutableClient executableClient;

    public ExecutableClient getExecutableClient(){
        return executableClient;
    }


    @PostConstruct
    public void init(){
        executableClient = ExecutableClient.getInstance();
        //DomainName不同环境对应不同域名，示例为sass域名
        executableClient.setDomainName(domainName);
        executableClient.setProtocal("https");
        //应用App Key
        executableClient.setAccessKey(key);
        //应用App Secret
        executableClient.setSecretKey(secret);
        executableClient.init();
    }
}
