package com.tykj.zydd.user.security;


import com.tykj.zydd.user.jwt.JwtSecurityConfigurer;
import com.tykj.zydd.user.jwt.JwtTokenProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import javax.annotation.Resource;


/**
 * @author zsp
 */
@Configuration
@EnableWebSecurity
public class SecurityConfig extends WebSecurityConfigurerAdapter {


    @Resource
    private JwtTokenProvider jwtTokenProvider;

    @Resource
    private MyEntryPoint myEntryPoint;

    @Resource
    UrlAccessDeniedHandler urlAccessDeniedHandler;


    @Bean
    @Override
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    @Bean
    public PasswordEncoder bCryptPasswordEncoder() {
        return new BCryptPasswordEncoder();
    }


    @Override
    protected void configure(HttpSecurity http) throws Exception {
        http.cors().and().csrf().disable()
                .sessionManagement()
//                .sessionFixation().changeSessionId().disable().sessionManagement()
                .sessionCreationPolicy(SessionCreationPolicy.STATELESS)
                .and()
                .authorizeRequests().antMatchers(HttpMethod.OPTIONS, "/**").permitAll()
                .antMatchers("/admin/register","/admin/loginSystem","/admin/loginByUserMessageVO").permitAll()
                //grace/app
                .antMatchers("/grace/app/**","/activity/app/**","/record/app/**","/science/ip/**","/admin/login",
                        "/user/getUserMessage","/user/getAccessToken").permitAll()
                .anyRequest().authenticated()
//                .anyRequest().permitAll()
                .and()
                .exceptionHandling()
                .accessDeniedHandler(urlAccessDeniedHandler)
                .authenticationEntryPoint(myEntryPoint)
                .and()
                .apply(new JwtSecurityConfigurer(jwtTokenProvider))
                .and();

    }

    @Override
    public void configure(WebSecurity web) {
        //swagger静态资源访问
        web.ignoring().antMatchers("/v2/api-docs", "/v2/api-docs-ext", "/configuration/ui",
                "/swagger-resources/**", "/configuration/security", "/swagger-ui/", "/swagger-ui/**", "" +
                        "/swagger-ui.html", "/doc.html", "/webjars/**", "/swagger-resources/configuration/ui",
                "**/swagger-ui.html", "**/**/index.html", "**/index.html", "/**/index.html", "/js/**",
                "/css/**", "/fonts/**", "/img/**","/access/send","/user/s","/druid/*","/file/**","/fonts/**"
               );
    }

}

