package com.tykj.zydd.user.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tykj.zydd.user.entity.KxAdmin;
import com.tykj.zydd.user.entity.KxPermissions;
import com.tykj.zydd.user.entity.KxRole;
import com.tykj.zydd.user.entity.KxUnit;
import com.tykj.zydd.user.entity.dto.UserInfo;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import javax.persistence.Transient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;


/**
 * @author zhoushaopan
 */
@Data
@Slf4j
public class SecurityUser implements UserDetails {

    private String token;

    private String username;

    private String account;

    @Transient
    private String password;


    private KxAdmin kxAdmin;

    public SecurityUser() {
    }




    /**
     * 获取当前用户所具有的角色
     *
     * @return
     */
    @Override
    @JsonIgnore
    @Transient
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return new ArrayList<>();
    }

    @Override
    @Transient
    public String getPassword() {
        return password;
    }

    @Override
    @JsonIgnore
    public boolean isAccountNonExpired() {
        return true;
    }

    @Override
    @JsonIgnore
    public boolean isAccountNonLocked() {
        return true;
    }

    @Override
    @JsonIgnore
    public boolean isCredentialsNonExpired() {
        return true;
    }

    @Override
    @JsonIgnore
    public boolean isEnabled() {
        return true;
    }

    @Override
    public String toString() {
        return this.username;
    }

    @Override
    public int hashCode() {
        return username.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());

    }
}