package com.tykj.zydd.user.service.impl;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tykj.zydd.user.dao.KxAdminDao;
import com.tykj.zydd.user.entity.KxAdmin;
import com.tykj.zydd.user.entity.dto.SystemUserVO;
import com.tykj.zydd.user.entity.vo.UserMessageVO;
import com.tykj.zydd.user.entity.vo.admin.LoginSystemVO;
import com.tykj.zydd.user.entity.vo.admin.RegisterVO;
import com.tykj.zydd.user.jwt.JwtTokenProvider;
import com.tykj.zydd.misc.constans.RedisKeyConstants;
import com.tykj.zydd.misc.constans.RedisTimeConstants;
import com.tykj.zydd.misc.exception.ApiException;
import com.tykj.zydd.misc.sm_utils.Sm3Util;
import com.tykj.zydd.user.security.MyUserDetailsServiceImpl;
import com.tykj.zydd.user.security.SecurityUser;
import com.tykj.zydd.user.service.KxAdminService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.concurrent.TimeUnit;

/**
 * @author: zsp
 * @create: 2022-12-14 10:27
 **/
@Service
@Slf4j
public class KxAdminServiceImpl implements KxAdminService {

    @Resource
    private KxAdminDao kxAdminDao;

    @Resource
    private MyUserDetailsServiceImpl myUserDetailsServiceImpl;

    @Resource
    private JwtTokenProvider jwtTokenProvider;

    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Resource
    private RestTemplate restTemplate;

//    @Value("${code.url}")
//    private String codeUrl;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public SecurityUser loginBySystem(LoginSystemVO loginSystemVO) {
        String account = loginSystemVO.getAccount();
        String password = loginSystemVO.getPassword();
        KxAdmin kxAdmin = kxAdminDao.findByAccount(account);
        SecurityUser userDetails = (SecurityUser) myUserDetailsServiceImpl.loadUserByUsername("0" + "Ǵ" + kxAdmin.getAccount());
        // 验证密码
        boolean verify = Sm3Util.verify(password+kxAdmin.getSalt(), userDetails.getPassword());
        if (!verify) {
            throw new ApiException("密码错误");
        }
        //生成token
        String token = jwtTokenProvider.createToken(kxAdmin.getAccount()+"", "0");
        userDetails.setToken(token);
        userDetails.setKxAdmin(kxAdmin);
        stringRedisTemplate.opsForValue().set(RedisKeyConstants.TOKEN+token, JSON.toJSONString(userDetails));
        stringRedisTemplate.expire(RedisKeyConstants.TOKEN+token, RedisTimeConstants.TOKEN_TIME, TimeUnit.MINUTES);
        return userDetails;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public KxAdmin registeredBySystem(RegisterVO registerVO) {
        String account = registerVO.getAccount();
        String password = registerVO.getPassword();
        String telephone = registerVO.getTelephone();
        KxAdmin kxAdmin = registerVO.toEntity();
        KxAdmin byAccount = kxAdminDao.findByAccount(account);
        KxAdmin byTelephone = kxAdminDao.findByTelephone(telephone);
        if (byAccount != null || byTelephone != null){
            throw new ApiException("账号已存在");
        }
        String salt = Sm3Util.getSalt();
        kxAdmin.setSalt(salt);
        kxAdmin.setPassword(Sm3Util.encrypt(password+salt));
        kxAdmin.setOrigin("0");
        return kxAdminDao.save(kxAdmin);
    }

    @Override
    public UserMessageVO loginByUserMessageVO(LoginSystemVO loginSystemVO) {
        UserMessageVO vo=new UserMessageVO();
        String account = loginSystemVO.getAccount();
        String password = loginSystemVO.getPassword();
        KxAdmin kxAdmin = kxAdminDao.findByAccount(account);
        vo.setAccountId(Integer.valueOf(kxAdmin.getAccount()));
        vo.setLastName(kxAdmin.getUsername());
        vo.setOrganizationName(kxAdmin.getOrganizationName());
        vo.setOrganizationCode(kxAdmin.getOrganizationCode());
        vo.setLevel(kxAdmin.getLevel());
        SecurityUser userDetails = (SecurityUser) myUserDetailsServiceImpl.loadUserByUsername("0" + "Ǵ" + kxAdmin.getAccount());
        // 验证密码
        boolean verify = Sm3Util.verify(password+kxAdmin.getSalt(), userDetails.getPassword());
        if (!verify) {
            throw new ApiException("密码错误");
        }
        //生成token
        String token = jwtTokenProvider.createToken(kxAdmin.getAccount()+"", "0");
        vo.setToken(token);
        userDetails.setToken(token);
        userDetails.setKxAdmin(kxAdmin);
        stringRedisTemplate.opsForValue().set(RedisKeyConstants.TOKEN+token, JSON.toJSONString(userDetails));
        stringRedisTemplate.expire(RedisKeyConstants.TOKEN+token, RedisTimeConstants.TOKEN_TIME, TimeUnit.MINUTES);
        return vo;
    }

//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public SecurityUser login(String code) {
//        //先检验code是否有效
//        String url =  codeUrl +"?code="+code;
//        ResponseEntity<String> forEntity = restTemplate.getForEntity(url, String.class);
//        String body = forEntity.getBody();
//        JSONObject jsonObject = JSONObject.parseObject(body);
//        log.info("login jsonObject:{}",jsonObject);
//        Object data = jsonObject.get("data");
//        if (data == null || "".equals(data)){
//            //code错误
//            throw new ApiException("请求code错误");
//        }
//        SystemUserVO systemUserVO = JSONObject.parseObject(JSON.toJSONString(data), SystemUserVO.class);
//        //判断本系统是否存在该用户
//        String userId = systemUserVO.getId();
//        String phone = systemUserVO.getPhone();
//        KxAdmin admin = kxAdminDao.findBySystemUserId(userId);
//        if (admin == null){
//            //说明不存在 需要存储在本系统
//            String encrypt = Sm3Util.encrypt("123456");
//            KxAdmin build = KxAdmin.builder()
//                    .account(phone)
//                    .telephone(phone)
//                    .password(encrypt)
//                    .salt(Sm3Util.getSalt())
//                    .origin("1")
//                    .systemUserId(userId)
//                    .username(systemUserVO.getUsername())
//                    .build();
//            admin = kxAdminDao.save(build);
//            log.info("存储用户信息");
//        }
//        //进行登录
//        SecurityUser userDetails = (SecurityUser) myUserDetailsServiceImpl.loadUserByUsername("0" + "Ǵ" + admin.getId());
//        //生成token
//        String token = jwtTokenProvider.createToken(admin.getId()+"", "0");
//        userDetails.setToken(token);
//        stringRedisTemplate.opsForValue().set(RedisKeyConstants.TOKEN+token, JSON.toJSONString(userDetails));
//        stringRedisTemplate.expire(RedisKeyConstants.TOKEN+token, RedisTimeConstants.TOKEN_TIME, TimeUnit.MINUTES);
//        return userDetails;
//    }
}
