package com.tykj.zydd.user.service.impl;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.zydd.misc.util.BeanCopyUtil;
import com.tykj.zydd.user.dao.SpecificUnitDao;
import com.tykj.zydd.user.dao.SpecificUserDao;
import com.tykj.zydd.user.dao.SpecificUserMessageDao;
import com.tykj.zydd.user.entity.KxAdmin;
import com.tykj.zydd.user.entity.SpecificUnit;
import com.tykj.zydd.user.entity.SpecificUser;
import com.tykj.zydd.user.entity.SpecificUserMessage;
import com.tykj.zydd.user.entity.vo.*;
import com.tykj.zydd.user.enums.AreaEnum;
import com.tykj.zydd.user.service.KxAdminService;
import com.tykj.zydd.user.service.UserDataService;
import com.tykj.zydd.user.utils.UserUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Service
public class UserDataServiceImpl implements UserDataService {

    @Resource
    private SpecificUnitDao specificUnitDao;

    @Resource
    private SpecificUserDao specificUserDao;

    @Resource
    private SpecificUserMessageDao specificUserMessageDao;

    @Resource
    private UserUtils userUtils;

    @Override
    public List<UnitMunicipalVO> getUnitList(String organizationName) {
        List<SpecificUnit> allByLevel;
        PredicateBuilder<SpecificUnit> predicateBuilder = Specifications.and();
        if (organizationName!=null){
            predicateBuilder.like("organizationName","%"+ organizationName+"%");
        }
        predicateBuilder.eq("level",1);
        List<SpecificUnit> all = specificUnitDao.findAll(predicateBuilder.build());
//        if (StringUtils.isEmpty(organizationName)) {
//            allByLevel = specificUnitDao.findAllByLevel(1);
//        } else {
//            allByLevel = specificUnitDao.findFirstByOrganizationNameAndLevel(organizationName, 1);
//        }
        List<UnitMunicipalVO> rs=new ArrayList<>();
        all.forEach(item->{
            UnitMunicipalVO vo=new UnitMunicipalVO();
            BeanUtils.copyProperties(item,vo);
            rs.add(vo);
        });
        return rs;
    }

//    @Override
//    public List<UnitMunicipalVO> getUnitList() {
//        KxAdmin currentUser = userUtils.getCurrentUser();
//        List<SpecificUnit> all = specificUnitDao.findAll();
//        Stream<SpecificUnit> specificUnitStream = all.stream().filter(a -> a.getOrganizationCode().equals(currentUser.getOrganizationCode()) || a.getParentCode().equals(currentUser.getOrganizationCode()));
//        List<UnitMunicipalVO> rs=new ArrayList<>();
//        specificUnitStream.forEach(item->{
//            UnitMunicipalVO vo=new UnitMunicipalVO();
//            BeanUtils.copyProperties(item,vo);
//            rs.add(vo);
//        });
//        return rs;
//    }

    @Override
    public List<DistrictUnitVO> getUnitVOList(String organizationName) {
        PredicateBuilder<SpecificUnit> predicateBuilder = Specifications.and();
        if (organizationName!=null){
            predicateBuilder.like("organizationName","%"+ organizationName+"%");
        }
        predicateBuilder.eq("level",2);
        List<SpecificUnit> allByLevel = specificUnitDao.findAll(predicateBuilder.build());
        List<SpecificUnit> specificUnits;
//        if (organizationName!=null){
//            specificUnits = allByLevel.stream().filter(a -> a.getOrganizationName().equals(organizationName)).collect(Collectors.toList());
//        }else {
//            specificUnits = new ArrayList<>(allByLevel);
//        }
        List<DistrictUnitVO> rs=new ArrayList<>();
        Map<String, List<SpecificUnit>> groupedUnits = allByLevel.stream()
                .collect(Collectors.groupingBy(SpecificUnit::getDivisionCode));
        for (Map.Entry<String, List<SpecificUnit>> entry : groupedUnits.entrySet()) {
            String divisionCode = entry.getKey().substring(0,6);
            List<SpecificUnit> units = entry.getValue();
            DistrictUnitVO groupVO = new DistrictUnitVO();
            groupVO.setName(AreaEnum.getNameByCode(divisionCode));
            List<UnitVO> children = new ArrayList<>();
            for (SpecificUnit unit : units) {
                UnitVO unitVO = new UnitVO();
                unitVO.setOrganizationCode(unit.getOrganizationCode());
                unitVO.setOrganizationName(unit.getOrganizationName());
                children.add(unitVO);
            }
            groupVO.setChildren(children);
            rs.add(groupVO);
        }

        return rs;
    }

    @Override
    public List<UserResultVO> getUserList(String organizationCode,String employeeName,Integer enable) {
        //聚合用户信息
        List<UserResultVO> userList = getUserList();
//        List<UserResultVO> collect = userList.stream().filter(a -> a.getOrganizationCode().equals(organizationCode)).collect(Collectors.toList());
        List<UserResultVO> collect = userList.stream()
                .filter(a -> organizationCode == null || a.getOrganizationCode().equals(organizationCode))
                .filter(a -> employeeName == null || a.getEmployeeName().equals(employeeName))
                .filter(a->enable==null || a.getEnable().equals(enable))
                .collect(Collectors.toList());
        return collect;
    }

    @Override
    public void updateEnable(Integer userId, Integer enable) {
        specificUserMessageDao.updateEnable(userId,enable);
    }

    @Override
    public List<SpecificUnit> getAllUnit() {
        return specificUnitDao.findAll();
    }


    public List<UserResultVO> getUserList(){
        List<SpecificUser> specificUserList=specificUserDao.findAll();
        List<SpecificUserMessage> all = specificUserMessageDao.findAll();
        //获取id 跟姓名
        List<UserVO> userVOS = BeanCopyUtil.copyCollectionObjects(specificUserList, UserVO::new);
        Map<Integer, SpecificUserMessage> messageMap = all.stream().collect(Collectors.toMap(SpecificUserMessage::getUserId, Function.identity()));
        Map<Integer, UserVO> userMap = userVOS.stream().collect(Collectors.toMap(UserVO::getId, Function.identity()));
        // 查找 id 相同的对象
        List<UserResultVO> result = messageMap.values().stream()
                .map(message -> {
                    UserResultVO rsVO=new UserResultVO();
                    UserVO user = userMap.get(message.getUserId());
                    rsVO.setEmployeeName(user.getEmployeeName());
                    rsVO.setUserId(message.getUserId());
                    rsVO.setEnable(message.getEnable());
                    rsVO.setOrganizationCode(message.getOrganizationCode());
                    return rsVO;
                })
                .collect(Collectors.toList());
       return result;
    }
}
