/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.xxpt.gateway.shared.client;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import org.apache.commons.lang3.ArrayUtils;

public class NetworkUtils {
    private static String ip = NetworkUtils.getIp();
    private static String mac = NetworkUtils.mac();

    public static String getIp() {
        return ip;
    }

    public static String getMac() {
        return mac;
    }

    private static String ip() {
        String ip = "127.0.0.1";
        try {
            InetAddress address = InetAddress.getLocalHost();
            ip = address.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return ip;
    }

    private static String mac() {
        try {
            InetAddress address = InetAddress.getLocalHost();
            byte[] mac = NetworkInterface.getByInetAddress(address).getHardwareAddress();
            if (ArrayUtils.isEmpty((byte[])mac)) {
                return "";
            }
            StringBuilder sb = new StringBuilder(17);
            for (int i = 0; i < mac.length; ++i) {
                int temp;
                String str;
                if (i != 0) {
                    sb.append(":");
                }
                if ((str = Integer.toHexString(temp = mac[i] & 0xFF)).length() == 1) {
                    sb.append("0" + str);
                    continue;
                }
                sb.append(str);
            }
            return sb.toString().toUpperCase();
        }
        catch (Exception exception) {
            return "";
        }
    }
}

