package com.tykj.zydd.misc.sm_utils;

import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.security.Security;

/**
 * SM4算法目前只支持128位（即密钥16字节）
 *
 * @author ozoz
 * @date 2023/8/23
 * @Description 加密敏感信息工具类
 **/
@SuppressWarnings("ALL")
public class Sm4Util {

    private static final String KEY = "tykj2023tykj2023";

    private static final String ALGORITHM_NAME = "SM4";
    private static final String ALGORITHM_NAME_ECB_PADDING = "SM4/ECB/PKCS5Padding";
    /**
     * SM4算法目前只支持128位（即密钥16字节）
     */
    private static final int DEFAULT_KEY_SIZE = 128;
    private static Object lock = new Object();
    static {
        Security.addProvider(new BouncyCastleProvider());
    }
    /**
     * 加密
     *
     * @param data 数据
     * @param key  秘钥
     * @return 密文
     */
    public static byte[] encrypt(byte[] data, byte[] key) throws Exception {

        SecretKey secretKey = new SecretKeySpec(key, ALGORITHM_NAME);
        Cipher cipher = Cipher.getInstance(ALGORITHM_NAME_ECB_PADDING,
                BouncyCastleProvider.PROVIDER_NAME);
        cipher.init(Cipher.ENCRYPT_MODE, secretKey);
        return cipher.doFinal(data);
    }


    public static String encrypt(String data, String key) {
        if (data == null) {
            return null;
        }
        try {
            //转换为标准的Base64字符串
            byte[] encrypt = Sm4Util.encrypt(data.getBytes(StandardCharsets.UTF_8), key.getBytes(StandardCharsets.UTF_8));
            return Base64.encodeBase64String(encrypt);
        } catch (Exception e) {
            return null;
        }
    }

    public static String encrypt(String data) {
       return encrypt(data, KEY);
    }

    /**
     * 解密
     *
     * @param data 数据
     * @param key  秘钥
     * @return 明文
     */
    public static byte[] decrypt(byte[] data, byte[] key) throws Exception {
        SecretKey secretKey = new SecretKeySpec(key, ALGORITHM_NAME);
        Cipher cipher = Cipher.getInstance(ALGORITHM_NAME_ECB_PADDING,
                BouncyCastleProvider.PROVIDER_NAME);
        cipher.init(Cipher.DECRYPT_MODE, secretKey);
        return cipher.doFinal(data);
    }

    /**
     * 解密
     *
     * @param data 数据
     * @param key  密钥
     * @return 明文
     * @throws Exception e
     */
    public static String decrypt(String data, String key) {
        if (data == null) {
            return null;
        }
        try {
            byte[] decryptBytes = Base64.decodeBase64(data);
            byte[] decrypt = Sm4Util.decrypt(decryptBytes, key.getBytes("UTF-8"));
            return new String(decrypt);
        } catch (Exception e) {
            return null;
        }

    }

    public static String decrypt(String data) {
        return decrypt(data, KEY);
    }

    public static void main(String[] args) throws Exception {

//        /**
//         * SM4算法目前只支持128位（即密钥16字节）
//         */
//        String key = "nXwqj7JVe@czbD4E";
//        System.out.println("key:" + key);
//        String data = "dasdsadsadqwefdsfdf热瓦甫企鹅我访问否dqfwq";
//
//        /**
//         * 加密
//         */
//        byte[] encrypt = Sm4Util.encrypt(data.getBytes("UTF-8"), key.getBytes("UTF-8"));
//        //转换为标准的Base64字符串
//        String encryptStr = Base64.encodeBase64String(encrypt);
//        System.out.println("加密:" + encryptStr);
//
//        /**
//         * 解密
//         */
//        byte[] decryptBytes = Base64.decodeBase64(encryptStr);
//        byte[] decrypt = Sm4Util.decrypt(decryptBytes, key.getBytes("UTF-8"));
//        String decryptStr = new String(decrypt);
//        System.out.println("解密:" + decryptStr);


        String decrypt = decrypt("6nAW06JHV+7aPxIj1XYJmw==", KEY);
        System.out.println(decrypt);

    }


}
