package com.tykj.zydd.misc.util;

import lombok.extern.slf4j.Slf4j;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;


@Slf4j
public class IDCardInformationUtils {


    /**
     * 根据身份证号获取年龄
     * @param idCardNumber 身份证号
     * @return
     */
    public static String getAge(String idCardNumber) {
        if (!NotNullUtil.stringNotNull(idCardNumber)){
            return "-1";
        }
        int currentYear = LocalDate.now().getYear();
        int birthYear = Integer.parseInt(idCardNumber.substring(6, 10));
        return (currentYear - birthYear)+"";
    }

    /**
     *  根据身份证号获取性别
     * @param idCardNumber
     * @return 0 男 1 女性 -1 未知
     */
    public static String getGender(String idCardNumber) {
        if (!NotNullUtil.stringNotNull(idCardNumber)){
            return "-1";
        }
        int genderCode = Integer.parseInt(idCardNumber.substring(16, 17));
        if (genderCode % 2 == 0) {
            return "1";
        } else {
            return "0";
        }
    }

    /**
     * 根据身份证号获取出生日期
     * @param idCardNumber
     * @return
     */
    public static String getDistrict(String idCardNumber) {
        if (!NotNullUtil.stringNotNull(idCardNumber)){
            return "未知";
        }
        Map<String, String> districtMap = new HashMap<>();
        districtMap.put("3301","杭州市");
        districtMap.put("3302","宁波市");
        districtMap.put("3303","温州市");
        districtMap.put("3304","嘉兴市");
        districtMap.put("3305","湖州市");
        districtMap.put("3306","绍兴市");
        districtMap.put("3307","金华市");
        districtMap.put("3308","衢州市");
        districtMap.put("3309","舟山市");
        districtMap.put("3310","台州市");
        districtMap.put("3311","丽水市");
        String substring = idCardNumber.substring(0, 4);
        log.info("substring = " + substring);
        return districtMap.getOrDefault(substring, "未知");
    }

    public static void main(String[] args) {
//        String idCardNumber = "410526199611145814";
        String idCardNumber = "410526199705062323";
        String age = getAge(idCardNumber);
        System.out.println("age = " + age);
        String gender = getGender(idCardNumber);
        System.out.println("gender = " + gender);
        String district = getDistrict(idCardNumber);
        System.out.println("district = " + district);

    }




}
