package com.tykj.zydd.pickup.service.impl;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.zydd.pickup.dao.TemplateDAO;
import com.tykj.zydd.pickup.entity.Template;
import com.tykj.zydd.pickup.entity.dto.TemplateDTO;
import com.tykj.zydd.pickup.service.PickUpService;
import com.tykj.zydd.pickup.service.TemplateService;
import com.tykj.zydd.user.entity.KxAdmin;
import com.tykj.zydd.user.entity.SpecificUnit;
import com.tykj.zydd.user.security.SecurityUser;
import com.tykj.zydd.user.utils.UserUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
public class TemplateServiceImpl implements TemplateService {

    @Resource
    private TemplateDAO templateDAO;

    @Resource
    private UserUtils userUtils;

    @Override
    public List<Template> getListTemplate() {
        KxAdmin currentUser = userUtils.getCurrentUser();
        PredicateBuilder<Template> predicateBuilder = Specifications.and();
        predicateBuilder.eq("organizationCode",currentUser.getOrganizationCode());
        return templateDAO.findAll(predicateBuilder.build());
    }

    @Override
    public void saveTemplate(TemplateDTO templateDTO) {
        KxAdmin currentUser = userUtils.getCurrentUser();
        if(templateDTO.getId()!=null){
            Template template = templateDAO.findById(templateDTO.getId()).get();
            BeanUtils.copyProperties(templateDTO, template, "createTime");
            template.setOrganizationCode(currentUser.getOrganizationCode());
            templateDAO.save(template);
        }else {
            Template template=new Template();
            template.setOrganizationCode(currentUser.getOrganizationCode());
            BeanUtils.copyProperties(templateDTO, template);
            templateDAO.save(template);
        }

    }

    @Override
    public void deleteById(int id) {
        Template template = templateDAO.findById(id).get();
        template.setDeleteTag(1);
        templateDAO.save(template);
    }


}
