package com.tykj.zydd.user.entity;

import com.tykj.zydd.misc.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;

import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zsp@mail.com
 * @date 2022/11/8
 */
@Entity
@ApiModel("单位实体类")
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@SQLDelete(sql = "update science_unit set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@Table(name =  "science_unit")
public class KxUnit extends BaseEntity {

    @ApiModelProperty(value = "单位名称")
    private String unitName;

    @ApiModelProperty(value = "单位类别ID")
    private Integer unitTypeId;

    @ApiModelProperty(value = "单位的等级")
    private Integer level;

    @ApiModelProperty(value = "父ID")
    private Integer parentId;

    @ApiModelProperty(value = "排序字段")
    private Integer showOrder;

    @ApiModelProperty(value = "地区code")
    private String area;

    @Transient
    private List<KxUnit> children = new ArrayList<>();

    public void addChildNode(KxUnit kxUnit) {
        children.add(kxUnit);
    }

}
