package com.tykj.zydd.user.security;


import com.tykj.zydd.misc.exception.ApiException;
import com.tykj.zydd.user.dao.KxAdminDao;
import com.tykj.zydd.user.entity.KxAdmin;
import com.tykj.zydd.user.entity.dto.UserInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author zjm
 */
@Service
@Slf4j
public class MyUserDetailsServiceImpl implements UserDetailsService {

    @Resource
    private KxAdminDao kxAdminDao;

    @Override
    public UserDetails loadUserByUsername(String username){
        SecurityUser securityUser = new SecurityUser();
        String[] split = username.split("Ǵ");
        // 获取ID
        String userId = split[1];
//        UserInfo userInfo = new UserInfo();
        if ("0".equals(split[0])){
            //说明是管理员登录
            KxAdmin kxAdmin = kxAdminDao.findByAccount(userId);
            if (kxAdmin == null) {
                throw new ApiException("用户不存在");
            }
            securityUser.setKxAdmin(kxAdmin);
            securityUser.setUsername(kxAdmin.getUsername());
            securityUser.setAccount(kxAdmin.getAccount( ));
            securityUser.setPassword(kxAdmin.getPassword());
            SecurityContextHolder.getContext().setAuthentication(new UsernamePasswordAuthenticationToken(securityUser,
                    securityUser.getKxAdmin().getPassword(),securityUser.getAuthorities()));
            return securityUser;
        }else {
            //说明是普通用户登录
            return securityUser;
        }
    }



}
