package com.tykj.zydd.user.utils;


import cn.hutool.core.util.ObjectUtil;
import com.tykj.zydd.user.entity.KxAdmin;
import com.tykj.zydd.user.security.SecurityUser;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;

@Component
public class UserUtils {

    public static String ANONYMOUS_USER_STRING = "anonymousUser";

    public SecurityUser getAuthentication(){
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            Object userObject = authentication.getPrincipal();
            if (ANONYMOUS_USER_STRING.equals(userObject)) {
                return null;
            }
            if (userObject instanceof SecurityUser) {
                return (SecurityUser) userObject;
            } else {
                return null;
            }
        } else {
            return null;
        }
    }

    public Integer getCurrentUserId() {
        SecurityUser authentication = getAuthentication();
        if (authentication != null) {
            return authentication.getKxAdmin().getId();
        } else {
            return null;
        }
    }


    public KxAdmin getCurrentUser() {
        SecurityUser authentication = getAuthentication();
        if (authentication != null) {
            return authentication.getKxAdmin();
        } else {
            throw new UsernameNotFoundException("当前无用户信息");
        }
    }


}
