//package com.tykj.zydd.misc.aop;
//
//
//import lombok.extern.slf4j.Slf4j;
//import org.aspectj.lang.JoinPoint;
//import org.aspectj.lang.annotation.AfterReturning;
//import org.aspectj.lang.annotation.Aspect;
//import org.aspectj.lang.annotation.Before;
//import org.aspectj.lang.annotation.Pointcut;
//import org.aspectj.lang.reflect.MethodSignature;
//import org.springframework.stereotype.Component;
//
//import java.lang.reflect.Method;
//
//@Slf4j
//@Aspect
//@Component
//public class TimerAspect {
//
//    private long startTime = 0;
//
//    @Pointcut("@annotation(com.tykj.tzdb.misc.aop.Timer)")
//    public void operateTimerPointCut(){
//    }
//
//    @Before("operateTimerPointCut()")
//    public void timerBefore(JoinPoint joinPoint){
//        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
//        Method method = signature.getMethod();
//        //拿timer的注解
//        Timer annotation = method.getAnnotation(Timer.class);
//        if (annotation != null){
//            startTime = System.currentTimeMillis();
//        }
//
//    }
//
//    @AfterReturning(pointcut = "operateTimerPointCut()")
//    public void timerAfter(JoinPoint joinPoint){
//        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
//        Method method = signature.getMethod();
//        //拿到timer的注解
//        Timer annotation = method.getAnnotation(Timer.class);
//        if (annotation != null){
//            long endTime = System.currentTimeMillis();
//            log.info(annotation.desc()+"耗时:{}",endTime-startTime+"ms");
//        }
//
//    }
//
//}
//
