package com.tykj.zydd.user.entity;

import com.tykj.zydd.misc.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.ArrayList;
import java.util.List;

/**
 * @author: zsp
 * @create: 2022-12-13 15:42
 **/
@Entity
@ApiModel("权限实体类")
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@SQLDelete(sql = "update science_permissions set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@Table(name = "science_permissions")
public class KxPermissions extends BaseEntity {

    @ApiModelProperty(value = "权限名称")
    private String permissionName;

    @ApiModelProperty(value = "父ID")
    private Integer permissionParentId;

    @ApiModelProperty(value = "等级")
    private Integer level;

    @Transient
    private List<KxPermissions> children = new ArrayList<>();

    public void addChildNode(KxPermissions kxPermissions) {
        children.add(kxPermissions);
    }

}
