package com.tykj.zydd.user.entity;

import com.tykj.zydd.misc.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @author zsp@mail.com
 * @date 2022/11/8
 */
@Entity
@ApiModel("单位和人中间表实体类")
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@SQLDelete(sql = "update kx_user_unit set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@Table(name = "kx_user_unit")
public class KxUserUnit extends BaseEntity {

    @ApiModelProperty(value = "人员Id")
    private Integer userId;

    @ApiModelProperty(value = "单位ID")
    private Integer unitId;


}
