package com.tykj.zydd.user.entity;

import com.tykj.zydd.misc.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;

import javax.persistence.Entity;

@Data
@ApiModel("专有钉钉单位表")
@Entity
@SQLDelete(sql = "update Specific_unit set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
public class SpecificUnit  extends BaseEntity {

    @ApiModelProperty(value = "行政区划code")
    private String divisionCode;


    @ApiModelProperty(value = "父组织名称")
    private String parentName;

    @ApiModelProperty(value = "显示名称")
    private String organizationName;

    @ApiModelProperty(value = "父组织Code")
    private String parentCode;

    @ApiModelProperty(value = "组织code")
    private String organizationCode;

    @ApiModelProperty(value = "排序码")
    private Integer displayOrder;

    @ApiModelProperty(value = "临时组织")
    private String typeName;

    @ApiModelProperty(value = "是否为末端节点，true为末端节点，false则说明还有子节点。")
    private String leaf;

    @ApiModelProperty(value = "创建时间")
    private String gmtCreate;

    @ApiModelProperty(value = "条线codes,多个用|拼接")
    private String businessStripCodes;

    @ApiModelProperty(value = "组织类型Code")
    private String typeCode;

    @ApiModelProperty(value = "组织状态")
    private String status;

    @ApiModelProperty(value = "地区级别 1市 2区县")
    private Integer level;
}
