package com.tykj.zydd.user.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.xxpt.gateway.shared.api.request.*;
import com.alibaba.xxpt.gateway.shared.api.response.*;
import com.alibaba.xxpt.gateway.shared.client.http.ExecutableClient;
import com.alibaba.xxpt.gateway.shared.client.http.IntelligentGetClient;
import com.alibaba.xxpt.gateway.shared.client.http.IntelligentPostClient;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.tykj.zydd.misc.constans.RedisKeyConstants;
import com.tykj.zydd.misc.constans.RedisTimeConstants;
import com.tykj.zydd.misc.exception.ApiException;
import com.tykj.zydd.misc.sm_utils.Sm3Util;
import com.tykj.zydd.misc.util.BeanCopyUtil;
import com.tykj.zydd.misc.util.EntityToVoUtil;
import com.tykj.zydd.misc.util.NotNullUtil;
import com.tykj.zydd.user.dao.KxAdminDao;
import com.tykj.zydd.user.dao.SpecificUnitDao;
import com.tykj.zydd.user.dao.SpecificUserDao;
import com.tykj.zydd.user.dao.SpecificUserMessageDao;
import com.tykj.zydd.user.entity.*;
import com.tykj.zydd.user.entity.dto.SendWorkMessageDTO;
import com.tykj.zydd.user.entity.dto.SpecificUnitDTO;
import com.tykj.zydd.user.entity.vo.SpecificUserVO;
import com.tykj.zydd.user.entity.vo.UserMessageVO;
import com.tykj.zydd.user.entity.vo.admin.RegisterVO;
import com.tykj.zydd.user.enums.AreaEnum;
import com.tykj.zydd.user.init.AppKeyInit;
import com.tykj.zydd.user.jwt.JwtTokenProvider;
import com.tykj.zydd.user.service.KxAdminService;
import com.tykj.zydd.user.service.ZyddUserService;
import lombok.extern.slf4j.Slf4j;
import org.hibernate.sql.Select;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.beans.Transient;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@Service
@Slf4j
public class ZyddUserServiceImpl implements ZyddUserService {

    @Resource
    private AppKeyInit appKeyInit;

    @Value("${tenantId}")
    private Long tenantId;

    @Resource
    private SpecificUnitDao specificUnitDao;

    @Resource
    private SpecificUserDao specificUserDao;

    @Resource
    private SpecificUserMessageDao specificUserMessageDao;
    @Resource
    private JwtTokenProvider jwtTokenProvider;

    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Resource
    private KxAdminService kxAdminService;

    @Resource
    private KxAdminDao kxAdminDao;
    @Override
    public String getAccessToken() {
        IntelligentGetClient intelligentGetClient = appKeyInit.getExecutableClient().newIntelligentGetClient("/gettoken.json");
        OapiGettokenJsonRequest oapiGettokenJsonRequest = new OapiGettokenJsonRequest();
        //应用的唯一标识key
        oapiGettokenJsonRequest.setAppkey(appKeyInit.getKey());
        //应用的密钥
        oapiGettokenJsonRequest.setAppsecret(appKeyInit.getSecret());
        //获取结果
        OapiGettokenJsonResponse apiResult = intelligentGetClient.get(oapiGettokenJsonRequest);
        String jsonResult = apiResult.getContent().getData();
        JSONObject jsonObject = JSON.parseObject(jsonResult);
        return jsonObject.getString("accessToken");
    }

    @Override
    @Transactional
    public UserMessageVO getUserMessage(String authCode) throws JsonProcessingException {
        IntelligentPostClient intelligentPostClient = appKeyInit.getExecutableClient().newIntelligentPostClient("/rpc/oauth2/dingtalk_app_user.json");
        OapiRpcOauth2DingtalkAppUserJsonRequest oapiRpcOauth2DingtalkAppUserJsonRequest = new OapiRpcOauth2DingtalkAppUserJsonRequest();
        //登录access_token
        oapiRpcOauth2DingtalkAppUserJsonRequest.setAccess_token(getAccessToken());
        //临时授权码
        oapiRpcOauth2DingtalkAppUserJsonRequest.setAuth_code(authCode);
        //获取结果
        OapiRpcOauth2DingtalkAppUserJsonResponse apiResult = intelligentPostClient.post(oapiRpcOauth2DingtalkAppUserJsonRequest);
        String jsonResult = apiResult.getContent();
        JSONObject jsonObject = JSON.parseObject(jsonResult);
        JSONObject contentObj = jsonObject.getJSONObject("content");
        Object data = contentObj.get("data");
        UserMessageVO userMessageVO = JSON.parseObject(data + "", UserMessageVO.class);
        KxAdmin byAccount = kxAdminDao.findByAccount(userMessageVO.getAccountId() + "");
        //获取用户所属单位
        String userUnitCode = getUserUnitCode(userMessageVO.getEmployeeCode());
        userMessageVO.setOrganizationCode(userUnitCode);
        String lastName = userMessageVO.getLastName();
        SpecificUnit organizationName = specificUnitDao.findFirstByOrganizationCode(userUnitCode);
        userMessageVO.setOrganizationName(organizationName.getOrganizationName());
        String intelligent = getIntelligent();
        if (userUnitCode.equals(intelligent)){
            userMessageVO.setLevel(0);
        }else {
            userMessageVO.setLevel(1);
        }
        if (byAccount==null){
            registeredBySystem(userMessageVO.getAccountId()+"",userUnitCode,lastName,organizationName.getOrganizationName(),userMessageVO.getLevel());
        }
        String token = jwtTokenProvider.createToken(userMessageVO.getAccountId()+"","0");
        stringRedisTemplate.opsForValue().set(RedisKeyConstants.TOKEN+token, JSON.toJSONString(userMessageVO));
        stringRedisTemplate.expire(RedisKeyConstants.TOKEN+token, RedisTimeConstants.TOKEN_TIME, TimeUnit.MINUTES);
        userMessageVO.setToken(token);
        return userMessageVO;
    }

    //一人一个单位
    public String getUserUnitCode(String employeeCode){
        String intelligent = getIntelligent();
        OapiMoziOrganizationPageOrganizationEmployeePositionsResponse specificUser = getUser(intelligent);
        String data = specificUser.getContent().getData();
        List<SpecificUserVO> specificUserVOS = JSONObject.parseArray(data + "", SpecificUserVO.class);
        SpecificUserVO specificUserVO = specificUserVOS.stream().filter(a -> a.getEmployeeCode().equals(employeeCode)).findFirst().orElse(new SpecificUserVO());
        List<SpecificUserMessage> govEmployeePositions = specificUserVO.getGovEmployeePositions();
        String organizationCode = null;
        for (SpecificUserMessage govEmployeePosition : govEmployeePositions) {
                organizationCode=govEmployeePosition.getOrganizationCode();
        }
        return organizationCode;
    }


    @Transactional(rollbackFor = Exception.class)
    public KxAdmin registeredBySystem(String accountId,String organizationCode,String lastName,String organizationName,Integer level) {
        String account = accountId;
        String password = "123456";
        KxAdmin kxAdmin = new KxAdmin();
        kxAdmin.setAccount(account);
        kxAdmin.setPassword(password);
        kxAdmin.setUsername(lastName);
        kxAdmin.setLevel(level);
        kxAdmin.setOrganizationName(organizationName);
        KxAdmin byAccount = kxAdminDao.findByAccount(account);
        if (byAccount != null){
            throw new ApiException("账号已存在");
        }
        String salt = Sm3Util.getSalt();
        kxAdmin.setSalt(salt);
        kxAdmin.setPassword(Sm3Util.encrypt(password+salt));
        kxAdmin.setOrigin("0");
        kxAdmin.setOrganizationCode(organizationCode);
        return kxAdminDao.save(kxAdmin);
    }

    @Override
    public OapiMoziFusionGetOrganizationTypesResponse getUnit() {
        //executableClient保证单例
        IntelligentGetClient intelligentGetClient = appKeyInit.getExecutableClient().newIntelligentGetClient("/mozi/fusion/getOrganizationTypes");
        OapiMoziFusionGetOrganizationTypesRequest oapiMoziFusionGetOrganizationTypesRequest = new OapiMoziFusionGetOrganizationTypesRequest();
        //租户id
        oapiMoziFusionGetOrganizationTypesRequest.setTenantId(tenantId);
        //获取结果
        OapiMoziFusionGetOrganizationTypesResponse apiResult = intelligentGetClient.get(oapiMoziFusionGetOrganizationTypesRequest);
        return apiResult;
    }

    @Override
    public String getIntelligent() {
        //executableClient保证单例
        IntelligentGetClient intelligentGetClient = appKeyInit.getExecutableClient().newIntelligentGetClient("/auth/scopesV2");
        OapiAuthScopesV2Request oapiAuthScopesV2Request = new OapiAuthScopesV2Request();
        //租户ID
        oapiAuthScopesV2Request.setTenantId(tenantId);
        //获取结果
        OapiAuthScopesV2Response apiResult = intelligentGetClient.get(oapiAuthScopesV2Request);
        String content = apiResult.getContent();
        JSONObject jsonObject = JSON.parseObject(content);
        Object code = jsonObject.get("deptVisibleScopes");
         return JSONArray.parseArray(code.toString()).getString(0);
    }

    @Override
    public List<String> getSubordinateOrganization(String organizationCodes) {
        List<String> rs = new ArrayList<>();
        rs.add(organizationCodes);
        if (!NotNullUtil.stringNotNull(organizationCodes)){
            return rs;
        }
        getDataList(organizationCodes,rs);
        return rs;
    }


    public void getDataList(String data, List<String> list){
        //executableClient保证单例
        IntelligentGetClient intelligentGetClient = appKeyInit.getExecutableClient().newIntelligentGetClient("/mozi/organization/pageSubOrganizationCodes");
        OapiMoziOrganizationPageSubOrganizationCodesRequest oapiMoziOrganizationPageSubOrganizationCodesRequest = new OapiMoziOrganizationPageSubOrganizationCodesRequest();
        oapiMoziOrganizationPageSubOrganizationCodesRequest.setReturnTotalSize(true);
        oapiMoziOrganizationPageSubOrganizationCodesRequest.setPageSize(10);
        oapiMoziOrganizationPageSubOrganizationCodesRequest.setOrganizationCode(data);
        oapiMoziOrganizationPageSubOrganizationCodesRequest.setPageNo(1);
        oapiMoziOrganizationPageSubOrganizationCodesRequest.setStatus("");
        oapiMoziOrganizationPageSubOrganizationCodesRequest.setTenantId(tenantId);
        //获取结果
        OapiMoziOrganizationPageSubOrganizationCodesResponse apiResult = intelligentGetClient.get(oapiMoziOrganizationPageSubOrganizationCodesRequest);
        String data1 = apiResult.getContent().getData();
        List<String> list1 = JSONObject.parseArray(data1, String.class);
        if (NotNullUtil.collectionNotNull(list1)){
            list.addAll(list1);
            list1.forEach(s -> {
                getDataList(s,list);
            });
        }
    }

    @Override
    public OapiMoziOrganizationListOrganizationsByCodesResponse getOrganizations(List<String> codeList) {
        //executableClient保证单例
        IntelligentPostClient intelligentPostClient = appKeyInit.getExecutableClient().newIntelligentPostClient("/mozi/organization/listOrganizationsByCodes");
        OapiMoziOrganizationListOrganizationsByCodesRequest oapiMoziOrganizationListOrganizationsByCodesRequest = new OapiMoziOrganizationListOrganizationsByCodesRequest();
        oapiMoziOrganizationListOrganizationsByCodesRequest.setOrganizationCodes(codeList);
        oapiMoziOrganizationListOrganizationsByCodesRequest.setTenantId(tenantId);
        //获取结果
        OapiMoziOrganizationListOrganizationsByCodesResponse apiResult = intelligentPostClient.post(oapiMoziOrganizationListOrganizationsByCodesRequest);
        String data = apiResult.getContent().getData();
        List<SpecificUnitDTO> specificUnits = JSONObject.parseArray(data, SpecificUnitDTO.class);
        List<SpecificUnit> rs=new ArrayList<>();
        for (SpecificUnitDTO specificUnitDTO : specificUnits) {
            SpecificUnit database = specificUnitDao.findFirstByOrganizationCode(specificUnitDTO.getOrganizationCode());
            if (database != null) {
//                CompareUtil.compareEntityToDto(database,SpecificUnitDTO.class,specificUnitDTO);
                BeanUtils.copyProperties(specificUnitDTO, database,"level");
                rs.add(database);
            } else {
                SpecificUnit specificUnit = new SpecificUnit();
                BeanUtils.copyProperties(specificUnitDTO, specificUnit);
                if (specificUnit.getDivisionCode()!=null){
                    String divisionCode = specificUnit.getDivisionCode().substring(0, 6);
                    specificUnit.setLevel(divisionCode.equals(AreaEnum.CS_HZ.getCode()) ? 1 : 2);
                }
                rs.add(specificUnit);
            }
        }
        specificUnitDao.saveAll(rs);
        return apiResult;
    }

    public OapiMoziOrganizationPageOrganizationEmployeePositionsResponse getUser(String organizationCodes) {
        //executableClient保证单例
        IntelligentGetClient intelligentGetClient = appKeyInit.getExecutableClient().newIntelligentGetClient("/mozi/organization/pageOrganizationEmployeePositions");
        OapiMoziOrganizationPageOrganizationEmployeePositionsRequest oapiMoziOrganizationPageOrganizationEmployeePositionsRequest = new OapiMoziOrganizationPageOrganizationEmployeePositionsRequest();
        //是否请求总数，默认是false
        oapiMoziOrganizationPageOrganizationEmployeePositionsRequest.setReturnTotalSize(true);
        //分页大小，默认是20，最大100
        oapiMoziOrganizationPageOrganizationEmployeePositionsRequest.setPageSize(100);
        //员工状态，A为有效，F为无效，默认是所有
        oapiMoziOrganizationPageOrganizationEmployeePositionsRequest.setEmployeeStatus("A");
        //组织code
        oapiMoziOrganizationPageOrganizationEmployeePositionsRequest.setOrganizationCode(organizationCodes);
        //请求起始页，默认是1
        oapiMoziOrganizationPageOrganizationEmployeePositionsRequest.setPageNo(1);
        //租户id
        oapiMoziOrganizationPageOrganizationEmployeePositionsRequest.setTenantId(tenantId);
        //获取结果
        return intelligentGetClient.get(oapiMoziOrganizationPageOrganizationEmployeePositionsRequest);
    }






    @Override
    @Transactional
    public OapiMoziOrganizationPageOrganizationEmployeePositionsResponse getSpecificUser(String organizationCodes) {
        //executableClient保证单例
        IntelligentGetClient intelligentGetClient = appKeyInit.getExecutableClient().newIntelligentGetClient("/mozi/organization/pageOrganizationEmployeePositions");
        OapiMoziOrganizationPageOrganizationEmployeePositionsRequest oapiMoziOrganizationPageOrganizationEmployeePositionsRequest = new OapiMoziOrganizationPageOrganizationEmployeePositionsRequest();
        //是否请求总数，默认是false
        oapiMoziOrganizationPageOrganizationEmployeePositionsRequest.setReturnTotalSize(true);
        //分页大小，默认是20，最大100
        oapiMoziOrganizationPageOrganizationEmployeePositionsRequest.setPageSize(100);
        //员工状态，A为有效，F为无效，默认是所有
        oapiMoziOrganizationPageOrganizationEmployeePositionsRequest.setEmployeeStatus("A");
        //组织code
        oapiMoziOrganizationPageOrganizationEmployeePositionsRequest.setOrganizationCode(organizationCodes);
        //请求起始页，默认是1
        oapiMoziOrganizationPageOrganizationEmployeePositionsRequest.setPageNo(1);
        //租户id
        oapiMoziOrganizationPageOrganizationEmployeePositionsRequest.setTenantId(tenantId);
        //获取结果
        OapiMoziOrganizationPageOrganizationEmployeePositionsResponse apiResult = intelligentGetClient.get(oapiMoziOrganizationPageOrganizationEmployeePositionsRequest);
        String data = apiResult.getContent().getData();
        List<SpecificUserVO> specificUserVOS = JSONObject.parseArray(data + "", SpecificUserVO.class);
        for (SpecificUserVO specificUserVO : specificUserVOS) {
            SpecificUser save = new SpecificUser();
            SpecificUser dataBase = specificUserDao.findFirstByEmployeeCode(specificUserVO.getEmployeeCode());
            if (dataBase != null) {
                BeanUtils.copyProperties(specificUserVO, dataBase);
                save = specificUserDao.save(dataBase);
            } else {
                BeanUtils.copyProperties(specificUserVO, save);
                save = specificUserDao.save(save);
            }

            //子信息
            List<SpecificUserMessage> govEmployeePositions = specificUserVO.getGovEmployeePositions();
            SpecificUser finalSave = save;
            List<SpecificUserMessage> collect = govEmployeePositions.stream().map(vo -> {
                SpecificUserMessage specificUserMessage = new SpecificUserMessage();
                BeanUtils.copyProperties(vo, specificUserMessage);
                specificUserMessage.setUserId(finalSave.getId());
                SpecificUserMessage findMessage = specificUserMessageDao.findFirstByEmployeeCode(specificUserMessage.getEmployeeCode());
                if (findMessage!=null){
                    Integer id = findMessage.getId();
                    BeanUtils.copyProperties(specificUserMessage, findMessage);
                    findMessage.setId(id);
                    return findMessage;
                }
                return specificUserMessage;
            }).collect(Collectors.toList());
            specificUserMessageDao.saveAll(collect);
        }
        return apiResult;
    }


    @Override
    public boolean sendWorkMessage(SendWorkMessageDTO sendWorkMessageDTO) {
        //executableClient保证单例
        IntelligentGetClient intelligentGetClient = appKeyInit.getExecutableClient().newIntelligentGetClient("/message/workNotification");
        OapiMessageWorkNotificationRequest oapiMessageWorkNotificationRequest = new OapiMessageWorkNotificationRequest();
        //接收者的部门id列表
        oapiMessageWorkNotificationRequest.setOrganizationCodes("");
        //接收人用户ID
        oapiMessageWorkNotificationRequest.setReceiverIds(sendWorkMessageDTO.getReceiverIds());
        //租户ID
        oapiMessageWorkNotificationRequest.setTenantId(tenantId+"");
        //业务消息id
        Random random=new Random();
        oapiMessageWorkNotificationRequest.setBizMsgId(random.nextInt()+"");
        //消息对象
        String msg = "{\n" +
                "  \"msgtype\": \"action_card\",\n" +
                "  \"action_card\": {\n" +
                "    \"title\": \"工作通知发送\",\n" +
                "    \"markdown\": \"" + sendWorkMessageDTO.getContent() + "\",\n" +
                "    \"btn_orientation\": \"1\",\n" +
                "    \"btn_json_list\": [\n" +
                "      {\n" +
                "        \"action_url\": \" \"\n" +
                "      }\n" +
                "    ]\n" +
                "  }\n" +
                "}";

        oapiMessageWorkNotificationRequest.setMsg(msg);
        //获取结果
        OapiMessageWorkNotificationResponse apiResult = intelligentGetClient.get(oapiMessageWorkNotificationRequest);
        if (!apiResult.getSuccess()){
            log.error("获取信息为："+JSONObject.toJSONString(apiResult));
            return false;
        }
        return true;
    }

    @Override
    public void cacheUnit() {
        //获取最大的code
        String intelligent = getIntelligent();
        //递归查询所有部门的code
        List<String> subordinateOrganization = getSubordinateOrganization(intelligent);
        //查询部门详情 入库
        getOrganizations(subordinateOrganization);
        //人员入库
        getSpecificUser(intelligent);
    }

    public static void main(String[] args) {
        Random random=new Random();
        int randomNumber = random.nextInt();
        System.out.println("randomNumber = " + randomNumber);
    }
}
