package com.tykj.zydd.user.utils;

import com.tykj.zydd.misc.util.SpringUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.domain.AuditorAware;

import java.util.Optional;

@Configuration
public class UserIDAuditorBean implements AuditorAware<Integer> {


    /**
     * 自动填充id
     * @return
     */
    @Override
    public Optional<Integer> getCurrentAuditor() {
        //获取当前用户Id并返回
        UserUtils userUtils = SpringUtils.getBean("userUtils");
        Integer userId = null;
        if (userUtils != null) {
            userId = userUtils.getCurrentUserId();
        }
        if (userId != null) {
            return Optional.of(userId);
        } else {
            return Optional.empty();
        }
    }
}
