package com.tykj.zydd.misc.util;

import lombok.extern.slf4j.Slf4j;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zsp
 * @create: 2023-12-21 14:33
 **/
@Slf4j
public class IpUtil {

    /**
     * 根据接口获取IP
     * @return ip
     */
    public static String getIpAddress(HttpServletRequest request) {
        String ipAddress = request.getHeader("X-Forwarded-For");
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getRemoteAddr();
        }
        log.info("ipAddress:{}", ipAddress);
        return ipAddress;
    }


    /**
     * 根据接口获取设备型号
     * @param request
     * @return
     */
    public static String getDeviceModel(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        log.info("userAgent:{}", userAgent);
        if (userAgent != null) {
            if (userAgent.contains("iPhone")) {
                return "iPhone";
            } else if (userAgent.contains("Android")) {
                return "Android";
            } else if (userAgent.contains("Windows")) {
                return "Windows";
            }else if (userAgent.contains("Macintosh")){
                return "MacOS";
            }
        }
        return "Unknown";
    }

    /**
     * 根据接口获取useragent
     * @param request
     * @return
     */
    public static String getUserAgent(HttpServletRequest request) {
        return request.getHeader("User-Agent");
    }

}
