package com.tykj.zydd.user.contorller;

import com.tykj.zydd.misc.swagger.AutoDocument;
import com.tykj.zydd.user.entity.SpecificUnit;
import com.tykj.zydd.user.entity.vo.DistrictUnitVO;
import com.tykj.zydd.user.entity.vo.UnitMunicipalVO;
import com.tykj.zydd.user.entity.vo.UnitVO;
import com.tykj.zydd.user.entity.vo.UserResultVO;
import com.tykj.zydd.user.service.UserDataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.repository.query.Param;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@RestController
@Api(tags = "人员信息")
@Slf4j
@RequestMapping("/ud")
@AutoDocument
public class UserDataController {


    @Resource
    private UserDataService userDataService;


//    @ApiOperation(value = "获取单位")
//    @GetMapping("/getUnitList")
//    public List<UnitMunicipalVO> getUnitList(){
//        return userDataService.getUnitList();
//    }


    @ApiOperation(value = "获取单位（市级 登录信息level为0）")
    @GetMapping("/getUnitList")
    public List<UnitMunicipalVO> getUnitList(String organizationName){
        return userDataService.getUnitList(organizationName);
    }



    @ApiOperation(value = "获取区单位")
    @GetMapping("/getUnitVOList")
    public  List<DistrictUnitVO> getUnitVOList(String organizationName){
        return userDataService.getUnitVOList(organizationName);
    }

    @ApiOperation(value = "根据单位code获取人员")
    @GetMapping("/getUserList")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "organizationCode", value = "单位code", dataType = "String"),
            @ApiImplicitParam(name = "employeeName", value = "姓名", dataType = "String"),
            @ApiImplicitParam(name = "enable", value = "是否可用", dataType = "Integer")})
    public List<UserResultVO> getUserList(String organizationCode,String employeeName,Integer enable){
        return userDataService.getUserList(organizationCode,employeeName,enable);
    }


    @ApiOperation(value = "对指定用户启用或停止")
    @GetMapping("/updateEnable")
    public void updateEnable( Integer userId, Integer enable){
        userDataService.updateEnable(userId,enable);
    }


    @ApiOperation(value = "获取所有单位")
    @GetMapping("/getAllUnit")
    public List<SpecificUnit> getAllUnit(){
        return userDataService.getAllUnit();
    }
}

