package com.tykj.zydd.user.dao;

import com.tykj.zydd.user.entity.KxUserUnit;
import com.tykj.zydd.user.entity.ScienceIp;
import com.tykj.zydd.user.entity.SpecificUnit;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

import java.util.List;

public interface SpecificUnitDao extends JpaRepository<SpecificUnit,Integer>, JpaSpecificationExecutor<SpecificUnit> {

    /**
     * 根据组织code查询
     */
    SpecificUnit findFirstByOrganizationCode(String organizationCode);


    /**
     * 根据等级查询单位列表
     */
    List<SpecificUnit> findAllByLevel(Integer level);

    /**
     * 根据组织名称查详情
     */
    List<SpecificUnit> findFirstByOrganizationNameAndLevel(String organizationName,Integer level);
}
