package com.tykj.zydd.user.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.tykj.zydd.misc.sm_utils.Sm4AttributeConverter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.time.LocalDateTime;

/**
 * @author: zsp
 * @create: 2023-12-29 11:34
 **/
@Entity
@ApiModel("记录IP登录日志")
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Table(name = "science_ip")
public class ScienceIp {

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    public Integer id;

    @ApiModelProperty(name =  "IP地址")
    public String ipAddress;

    @ApiModelProperty(name =  "设备型号")
    public String modelOrigin;

    @ApiModelProperty(name =  "设备型号")
    @Column(columnDefinition = "text")
    public String userAgent;

    @ApiModelProperty(name = "登录用户名")
    @Convert(converter = Sm4AttributeConverter.class)
    public String username;

    @ApiModelProperty(name = "登录时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    public LocalDateTime loginTime;
}
