package com.tykj.zydd.user.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.tykj.zydd.misc.base.BaseEntity;
import com.tykj.zydd.misc.sm_utils.Sm4AttributeConverter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.format.annotation.DateTimeFormat;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Transient;
import java.time.LocalDate;

/**
 * @author zsp
 * @date 2022/9/22
 */
@Entity
@ApiModel("用户实体类")
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@SQLDelete(sql = "update science_user set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
public class ScienceUser extends BaseEntity {

    @ApiModelProperty(value = "用户名",example = "张三")
    @Convert(converter = Sm4AttributeConverter.class)
    private String userName;

    @ApiModelProperty(value = "密码",example = "123")
    private String password;

    @ApiModelProperty(value = "登陆时间",example = "2022-10-01")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private LocalDate loginDate;

    @ApiModelProperty(value = "浙里办的人的唯一标识",example = "张a")
    private String userIdentity;

    @ApiModelProperty(value = "电话号码",example = "123")
    @Convert(converter = Sm4AttributeConverter.class)
    private String telephone;

}
