package com.tykj.zydd.user.entity.vo.admin;

import com.tykj.zydd.user.entity.KxAdmin;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.beans.BeanUtils;

/**
 * @author: zsp
 * @create: 2023-12-27 10:01
 **/
@AllArgsConstructor
@NoArgsConstructor
@Data
@ApiModel(value = "注册admin人员vo")
public class RegisterVO {

    @ApiModelProperty(value = "电话号码",example = "123")
    private String telephone;

    @ApiModelProperty(value = "账号",example = "123")
    private String account;

    @ApiModelProperty(name = "密码",value = "密码",example = "123")
    private String password;

    public KxAdmin toEntity(){
        KxAdmin kxAdmin = new KxAdmin();
        BeanUtils.copyProperties(this, kxAdmin);
        return kxAdmin;
    }
}
